package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCellFormat;

public class MetaGridCellFormatAction extends BaseDomAction<MetaGridCellFormat> {

	@Override
	public void load(Document document, Element element,
			MetaGridCellFormat meta, int runType) {
		meta.setHAlign(HAlignment.parse(DomHelper.readAttr(element, MetaConstants.FORMAT_HALIGN, HAlignment.STR_LEFT)));
		meta.setVAlign(VAlignment.parse(DomHelper.readAttr(element, MetaConstants.FORMAT_VALIGN, VAlignment.STR_CENTER)));
		meta.setLeftBorder(DomHelper.readAttr(element, MetaConstants.FORMAT_LEFTBORDER, false));
		meta.setTopBorder(DomHelper.readAttr(element, MetaConstants.FORMAT_TOPBORDER, false));
		meta.setRightBorder(DomHelper.readAttr(element, MetaConstants.FORMAT_RIGHTBORDER, false));
		meta.setBottomBorder(DomHelper.readAttr(element, MetaConstants.FORMAT_BOTTOMBORDER, false));
	}

	@Override
	public void save(Document document, Element element,
			MetaGridCellFormat meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.FORMAT_HALIGN, HAlignment.toString(meta.getHAlign()), HAlignment.STR_LEFT);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_VALIGN, VAlignment.toString(meta.getVAlign()), VAlignment.STR_CENTER);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_LEFTBORDER, meta.isLeftBorder(), false);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_TOPBORDER, meta.isTopBorder(), false);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_RIGHTBORDER, meta.isRightBorder(), false);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_BOTTOMBORDER, meta.isBottomBorder(), false);
	}

}
