package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CustomDataType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaCellCustomData;

public class MetaCellCustomDataAction extends BaseDomAction<MetaCellCustomData>{

	@Override
	public void load(Document document, Element element, MetaCellCustomData meta,
			int runType) {
		meta.setType(CustomDataType.parse(DomHelper.readAttr(element, MetaConstants.CUSTOM_DATA_TYPE, CustomDataType.STR_EXPAND)));
		meta.setTag(DomHelper.readAttr(element, MetaConstants.CUSTOM_DATA_TAG, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.CUSTOM_DATA_TABLEKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaCellCustomData meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.CUSTOM_DATA_TYPE, CustomDataType.toString(meta.getType()), CustomDataType.STR_EXPAND);
		DomHelper.writeAttr(element, MetaConstants.CUSTOM_DATA_TAG, meta.getTag(), "");
		DomHelper.writeAttr(element, MetaConstants.CUSTOM_DATA_TABLEKEY, meta.getTableKey(), "");
	}

}
