package com.bokesoft.yes.meta.persist.dom.form.component.control.refresh;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshHeader;

public class MetaRefreshHeaderAction extends MetaBaseScriptAction<MetaRefreshHeader> {
	@Override
	public void load(Document document, Element element, MetaRefreshHeader meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setText(DomHelper.readAttr(element, MetaConstants.COMMON_TEXT, null));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, null));
		meta.setIconLocation(IconLocationType.parse(DomHelper.readAttr(element, MetaConstants.REFRESHCONTROL_ICONLOCATION, IconLocationType.STR_LEFT)));
	}

	@Override
	public void save(Document document, Element element, MetaRefreshHeader meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_TEXT, meta.getText(),null);
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), null);
		DomHelper.writeAttr(element, MetaConstants.REFRESHCONTROL_ICONLOCATION, IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
	}
}
