package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.DictItemKeySourceType;
import com.bokesoft.yigo.common.def.DictLoadType;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;

public class MetaDictExtPropertiesAction extends DomPropertiesAction<MetaDictProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaDictProperties meta, int runType) {
		meta.setItemKey(DomHelper.readAttr(element, MetaConstants.DICT_ITEMKEY, null));
		meta.setDynamic(DomHelper.readBool(element, MetaConstants.DICT_ISDYNAMIC, null));
		meta.setCompDict(DomHelper.readBool(element, MetaConstants.DICT_ISCOMPDICT, null));
		meta.setAllowMultiSelection(DomHelper.readBool(element, MetaConstants.DICT_ALLOWMULTISELECTION, null));
		meta.setRoot(DomHelper.readAttr(element, MetaConstants.DICT_ROOT, null));
		meta.setRefKey(DomHelper.readAttr(element, MetaConstants.DICT_REFKEY, null));
		meta.setRefDataElementKey(DomHelper.readAttr(element, MetaConstants.DICT_REFDATAELEMENTKEY, null));
		meta.setIndependent(DomHelper.readBool(element, MetaConstants.DICT_INDEPENDENT, null));
		meta.setStateMask(DictStateMask.parse(DomHelper.readAttr(element, MetaConstants.DICT_STATEMASK, "")));
		meta.setStateMaskFormula(DomHelper.readAttr(element, MetaConstants.DICT_STATEMASK_FORMULA, null));
		meta.setItemKeySourceType(DictItemKeySourceType.parse(DomHelper.readAttr(element, MetaConstants.DICT_ITEMKEYSOURCETYPE, "")));
		meta.setItemKeySource(DomHelper.readAttr(element, MetaConstants.DICT_ITEMKEYSOURCE, null));
		meta.setIgnoreRights(DomHelper.readBool(element, MetaConstants.DICT_IGNORERIGHTS, null));
		meta.setLoadType(DictLoadType.parse(DomHelper.readAttr(element, MetaConstants.DICT_LOADTYPE, null)));
		meta.setFormulaText(DomHelper.readAttr(element, MetaConstants.DICT_FORMULATEXT, ""));
		meta.setTextField(DomHelper.readAttr(element, MetaConstants.DICT_TEXTFIELD, ""));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.TEXT_PROMPTTEXT, null));
		meta.setPromptData(DomHelper.readBool(element, MetaConstants.DICT_PROMPTDATA, null));
		meta.setBrowserFormKey(DomHelper.readAttr(element, MetaConstants.DICT_BROWSER_FORM_KEY, null));
		meta.setEditValue(DomHelper.readBool(element, MetaConstants.DICT_EDIT_VALUE, null));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaDictProperties meta, int runType) {

	}

}
