package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;

public class MetaUTCDatePickerPropertiesAction extends MetaDatePickerPropertiesAction {

	@Override
	public void loadImpl(Document document, Element element, MetaDatePickerProperties meta, int runType) {
		super.loadImpl(document, element, meta, runType);
		meta.setOnlyDate(DomHelper.readAttr(element, MetaConstants.DATEPICKER_ONLYDATE, true));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaDatePickerProperties meta, int runType) {
		super.saveImpl(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.DATEPICKER_ONLYDATE, meta.isOnlyDate(), true);
	}

}
