package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelProperties;

public class MetaPriceLabelPropertiesAction extends DomPropertiesAction<MetaPriceLabelProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaPriceLabelProperties meta, int runType) {
		meta.setPreText(DomHelper.readAttr(element, MetaConstants.PRICELABEL_PRETEXT, ""));
		meta.setDecimalDigits(DomHelper.readAttr(element, MetaConstants.PRICELABEL_DECIMALDIGITS, 2));
		meta.setShowThousandth(DomHelper.readAttr(element, MetaConstants.PRICELABEL_SHOWTHOUSANDTH, true));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaPriceLabelProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PRICELABEL_PRETEXT, meta.getPreText(), "");
		DomHelper.writeAttr(element, MetaConstants.PRICELABEL_DECIMALDIGITS, meta.getDecimalDigits(), 2);
		DomHelper.writeAttr(element, MetaConstants.PRICELABEL_SHOWTHOUSANDTH, meta.getShowThousandth(), true);
	}

}
