package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.PasswordEditorStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPasswordEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;

public class MetaPasswordEditorPropertiesAction extends MetaTextEditorPropertiesAction{

	@Override
	public void loadImpl(Document document, Element element,
			MetaTextEditorProperties meta, int runType) {
		super.loadImpl(document, element, meta, runType);
		MetaPasswordEditorProperties properties = (MetaPasswordEditorProperties)meta;
		String safeInput = DomHelper.readAttr(element, MetaConstants.PASSWORDEDITOR_SAFEINPUT, null);
		if(safeInput != null){
			properties.setSafeInput(Boolean.parseBoolean(safeInput));
		}
		String showSwitchIcon = DomHelper.readAttr(element, MetaConstants.PASSWORDEDITOR_SHOWSWITCHICON, null);
		if(showSwitchIcon != null){
			properties.setShowSwitchIcon(Boolean.parseBoolean(showSwitchIcon));
		}
		String style = DomHelper.readAttr(element, MetaConstants.PASSWORDEDITOR_STYLE, null);
		if(style != null){
			int styleValue = PasswordEditorStyle.parse(style);
			properties.setStyle(styleValue);
			if(styleValue == PasswordEditorStyle.BOX || styleValue == PasswordEditorStyle.UNDERLINE){
				meta.setMaxLength(DomHelper.readAttr(element, MetaConstants.TEXT_MAXLENGTH, 6));
			}
		}
		String showPlainText = DomHelper.readAttr(element, MetaConstants.PASSWORDEDITOR_SHOWPLAINTEXT, null);
		if(showPlainText != null){
			properties.setShowPlainText(Boolean.parseBoolean(showPlainText));
		}
		String spacing = DomHelper.readAttr(element, MetaConstants.PASSWORDEDITOR_SPACING, null);
		if(spacing != null){
			properties.setSpacing(DefSize.parse(spacing));
		}
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaTextEditorProperties meta, int runType) {
		super.saveImpl(document, element, meta, runType);
		MetaPasswordEditorProperties properties = (MetaPasswordEditorProperties)meta;
		DomHelper.writeAttr(element, MetaConstants.PASSWORDEDITOR_SAFEINPUT, properties.isSafeInput(), false);
		DomHelper.writeAttr(element, MetaConstants.PASSWORDEDITOR_SHOWSWITCHICON, properties.isShowSwitchIcon(), true);
		DomHelper.writeAttr(element, MetaConstants.PASSWORDEDITOR_STYLE, PasswordEditorStyle.format(properties.getStyle()), PasswordEditorStyle.STR_NORMAL);
		DomHelper.writeAttr(element, MetaConstants.PASSWORDEDITOR_SHOWPLAINTEXT, properties.isShowPlainText(), false);
		DomHelper.writeAttr(element, MetaConstants.PASSWORDEDITOR_SPACING, properties.getSpacing().toString(), DefSize.parse("0dp").toString());
	}

}
