package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.RollingType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountUpProperties;

public class MetaCountUpPropertiesAction extends DomPropertiesAction<MetaCountUpProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaCountUpProperties meta, int runType) {
		meta.setRollingType(RollingType
				.parser(DomHelper.readAttr(element, MetaConstants.COUNTUP_ROLLINGTYPE, RollingType.STR_RIGHT)));
		String rollingLinesStr = DomHelper.readAttr(element, MetaConstants.COUNTUP_ROLLINGLINES, null);
		if (rollingLinesStr != null && !rollingLinesStr.isEmpty()) {
			meta.setRollingLines(TypeConvertor.toInteger(rollingLinesStr));
		}
	}

	@Override
	public void saveImpl(Document document, Element element, MetaCountUpProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COUNTUP_ROLLINGTYPE, RollingType.toString(meta.getRollingType()),
				RollingType.STR_RIGHT);
		DomHelper.writeAttr(element, MetaConstants.COUNTUP_ROLLINGLINES, meta.getRollingLines(), 15);
	}

}
