package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ComboFilterType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboFilter;

public class MetaComboFilterAction extends DomPropertiesAction<MetaComboFilter> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaComboFilter meta, int runType) {
		meta.setType(ComboFilterType.parse(DomHelper.readAttr(element, MetaConstants.COMBOFILTER_TYPE, ComboFilterType.STR_Filter)));
		meta.setSourceType(ComboBoxSourceType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_SOURCETYPE, ComboBoxSourceType.STR_ITEMS)));
		meta.setItemsDependency(DomHelper.readAttr(element, MetaConstants.COMBOBOX_ITEMS_DEPENDENCY, ""));
	}
	
	@Override
	public void saveImpl(Document document, Element element,
			MetaComboFilter meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMBOFILTER_TYPE, ComboFilterType.toString(meta.getType()), ComboFilterType.STR_Filter);
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_SOURCETYPE, ComboBoxSourceType.format(meta.getSourceType()), ComboBoxSourceType.STR_ITEMS);
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_ITEMS_DEPENDENCY, meta.getItemsDependency(), "");
	}

}
