package com.bokesoft.yes.meta.persist.dom.form.component.control.navigationlist;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationItem;

public class MetaNavigationItemAction extends BaseDomAction<MetaNavigationItem> {

	@Override
	public void load(Document document, Element element, MetaNavigationItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setEntryKey(DomHelper.readAttr(element, MetaConstants.NAVIGATIONITEM_ENTRYKEY, ""));
		String entryFilterStr = DomHelper.readAttr(element, MetaConstants.NAVIGATIONITEM_ENTRYFILTER, null);
		if(entryFilterStr != null && !entryFilterStr.isEmpty()){
			meta.setEntryFilter(Boolean.parseBoolean(entryFilterStr));
		}
		meta.setImageScaleType(ImageScaleType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, "")));
		meta.setOnclick(DomHelper.readCDATAContent(element).trim().intern());
	}

	@Override
	public void save(Document document, Element element, MetaNavigationItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.NAVIGATIONITEM_ENTRYKEY, meta.getEntryKey(), "");
		DomHelper.writeAttr(element, MetaConstants.NAVIGATIONITEM_ENTRYFILTER, meta.isEntryFilter() == null ? null : meta.isEntryFilter().toString(), null);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE,ImageScaleType.toString(meta.getImageScaleType()),"");
		DomHelper.writeCDATAContent(document, element, meta.getOnclick());
	}

}
