package com.bokesoft.yes.meta.persist.dom.form.component.control.map;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.MapDrawType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.map.MetaMapDraw;

public class MetaMapDrawAction extends MetaComponentAction<MetaMapDraw> {
	
	@Override
	public void load(Document document, Element element, MetaMapDraw meta,
			int runType) {
		super.load(document, element, meta, runType);
		int type = MapDrawType.parse(DomHelper.readAttr(element, MetaConstants.MAP_TYPE, "BAIDU"));
		meta.setType(type);
		String url = DomHelper.readAttr(element, MetaConstants.MAP_URL, "");
		meta.setURL(url);
		
	}
	
	@Override
	public void save(Document document, Element element, MetaMapDraw meta,
			int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.MAP_TYPE, MapDrawType.toString(meta.getType()), "BAIDU");
		DomHelper.writeAttr(element, MetaConstants.MAP_URL,meta.getURL(), "");
	}
}
