package com.bokesoft.yes.meta.persist.dom.form.component.control.listview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.editview.MetaEditViewAction;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRotator;

public class MetaRotatorAction extends MetaEditViewAction<MetaRotator> {
	@Override
	public void load(Document document, Element element, MetaRotator meta, int runType) {
		super.load(document, element, meta, runType);
		String intervalTimeStr = DomHelper.readAttr(element, MetaConstants.ROTATOR_INTERVALTIME, "");
		meta.setIntervalTime(intervalTimeStr != null && !intervalTimeStr.isEmpty() ? Double.parseDouble(intervalTimeStr) : 0);
		meta.setRepeat(DomHelper.readAttr(element, MetaConstants.GALLERY_REPEAT, true));
		meta.setIndicator(DomHelper.readAttr(element, MetaConstants.GALLERY_INDICATOR, true));
		meta.setIndicatorLocation(HAlignment.parse(DomHelper.readAttr(element, MetaConstants.GALLERY_INDICATOR_LOCATION, "")));
		meta.setPagination(DomHelper.readAttr(element, MetaConstants.GALLERY_PAGINATION, false));
		String animTimeStr = DomHelper.readAttr(element, MetaConstants.ROTATOR_ANIM_TIME, "");
		meta.setAnimTime(animTimeStr != null && !animTimeStr.isEmpty() ? Double.parseDouble(animTimeStr) : 0);
	}

	@Override
	public void save(Document document, Element element, MetaRotator meta, int runType) {
		super.save(document, element, meta, runType);
		Double intervalTime = meta.getIntervalTime();
		String intervalTimeStr = intervalTime == 0 ? "" : intervalTime.toString();
		DomHelper.writeAttr(element, MetaConstants.ROTATOR_INTERVALTIME, intervalTimeStr, "");
		DomHelper.writeAttr(element, MetaConstants.GALLERY_REPEAT, meta.isRepeat(), true);
		DomHelper.writeAttr(element, MetaConstants.GALLERY_INDICATOR, meta.isIndicator(), true);
		DomHelper.writeAttr(element, MetaConstants.GALLERY_INDICATOR_LOCATION, HAlignment.toString(meta.getIndicatorLocation()), "");
		DomHelper.writeAttr(element, MetaConstants.GALLERY_PAGINATION, meta.isPagination(), false);
		Double animTime = meta.getAnimTime();
		String animTimeStr = animTime == 0 ? "" : animTime.toString();
		DomHelper.writeAttr(element, MetaConstants.ROTATOR_ANIM_TIME, animTimeStr, "");
	}
}
