package com.bokesoft.yes.meta.persist.dom.form.component.control.listview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.ItemAnimType;
import com.bokesoft.yigo.common.def.ListViewSortType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;

public class MetaListViewAction<T extends MetaListView> extends MetaComponentAction<T> {
	@Override
	public void load(Document document, Element element, T meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
		meta.setPageRowCount(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PAGEROWCOUNT, 50));
		meta.setRowHeight(DomHelper.readAttr(element, MetaConstants.LISTVIEW_ROWHEIGHT, -1));
		meta.setPageLoadType(PageLoadType.parse(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PAGELOADTYPE, PageLoadType.STR_NONE)));
		meta.setShowHead(DomHelper.readAttr(element, MetaConstants.LISTVIEW_SHOWHEAD, false));
		meta.setDefaultSelectRow(DomHelper.readAttr(element, MetaConstants.LISTVIEW_DEFAULTSELECTROW, -1));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.PROMPTTEXT, ""));
		meta.setPromptImage(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PROMPTIMAGE, ""));
		meta.setPromptRowCount(DomHelper.readAttr(element, MetaConstants.LISTVIEW_PROMPTROWCOUNT, meta.getDefaultPromptRowCount()));
		meta.setItemAnim(DomHelper.readAttr(element, MetaConstants.LISTVIEW_ITEMANIM, ItemAnimType.FADEIN));
		meta.setLayoutAnim(DomHelper.readAttr(element, MetaConstants.COMPONENT_LAYOUTANIM, ""));
		meta.setScrollXY(DomHelper.readAttr(element, MetaConstants.LISTVIEW_SCROLLXY, false));
		meta.setOrientation(OrientationType.parse(
				DomHelper.readAttr(element, MetaConstants.COMPONENT_ORIENTATION, OrientationType.toString(meta.getDefaultOrientation()))));
		meta.setShowTotalRowCount(DomHelper.readBool(element, MetaConstants.LISTVIEW_SHOWTOTALROWCOUNT, (Boolean)null));
		meta.setEditRowFormKey(DomHelper.readAttr(element, MetaConstants.GRID_EDITROWFORMKEY, ""));
		meta.setSortType(ListViewSortType.parse(DomHelper.readAttr(element, MetaConstants.LISTVIEW_SORTTYPE, ListViewSortType.STR_CurrentPage)));
	}

	@Override
	public void save(Document document, Element element, T meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_PAGEROWCOUNT, meta.getPageRowCount(), 50);
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_ROWHEIGHT, meta.getRowHeight(), -1);
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_PAGELOADTYPE,PageLoadType.toString(meta.getPageLoadType()), PageLoadType.STR_NONE);
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_SHOWHEAD, meta.isShowHead(), false);
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_DEFAULTSELECTROW, meta.getDefaultSelectRow(), -1);
		DomHelper.writeAttr(element, MetaConstants.PROMPTTEXT, meta.getPromptText(), "");
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_PROMPTIMAGE, meta.getPromptImage(), "");
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_PROMPTROWCOUNT, meta.getPromptRowCount(), meta.getDefaultPromptRowCount());
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_ITEMANIM, meta.getItemAnim(), ItemAnimType.FADEIN);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_LAYOUTANIM, meta.getLayoutAnim(), "");
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_SCROLLXY, meta.isScrollXY(), false);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_ORIENTATION, 
				OrientationType.toString(meta.getOrientation()), OrientationType.toString(meta.getDefaultOrientation()));
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_SHOWTOTALROWCOUNT, meta.isShowTotalRowCount(), null);
		DomHelper.writeAttr(element, MetaConstants.GRID_EDITROWFORMKEY, meta.getEditRowFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.LISTVIEW_SORTTYPE, ListViewSortType.toString(meta.getSortType()), ListViewSortType.STR_CurrentPage);
	}
}
