package com.bokesoft.yes.meta.persist.dom.form.component.control.gantt;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttColumn;

public class MetaGanttColumnAction extends BaseDomAction<MetaGanttColumn> {

	@Override
	public void load(Document document, Element element, MetaGanttColumn meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setColumnKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_COLUMNKEY, ""));
		meta.setTree(DomHelper.readAttr(element, "Tree", false));
		meta.setFormat(DomHelper.readAttr(element, "Format", ""));
		meta.setWidth(DomHelper.readAttr(element, "Width", ""));
		meta.setDateFormat(DomHelper.readAttr(element, "DateFormat", ""));
		meta.setDateTimeFormat(DomHelper.readAttr(element, "DateTimeFormat", ""));
		meta.setVisible(DomHelper.readAttr(element,MetaConstants.COMMON_VISIBLE, ""));
		meta.setDefaultFormulaValue(DomHelper.readAttr(element,MetaConstants.COMMON_DEFAULTFORMULAVALUE, ""));
		meta.setColumnType(ControlType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_TYPE, ControlType.STR_LABEL)));
	}

	@Override
	public void save(Document document, Element element, MetaGanttColumn meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, "Tree", meta.isTree(), false);
		DomHelper.writeAttr(element, MetaConstants.DATEPICKER_FORMAT, meta.getFormat(), "");
		DomHelper.writeAttr(element, "DateFormat", meta.getDateFormat(), "");
		DomHelper.writeAttr(element, "Width", meta.getWidth(), "");
		DomHelper.writeAttr(element, "DateTimeFormat", meta.getDateTimeFormat(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.isVisible(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_TYPE, ControlType.toString(meta.getColumnType()),
				ControlType.STR_LABEL);
	}
}
