package com.bokesoft.yes.meta.persist.dom.form.component.control.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentExtAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaShrinkView;

public class MetaShrinkViewExtAction extends MetaComponentExtAction<MetaShrinkView>{

	public MetaShrinkViewExtAction() {
		super();
	}
	
	@Override
	public void load(Document document, Element element, MetaShrinkView meta, int runType) {
		super.load(document, element, meta, runType);
		String toolBarHeight = DomHelper.readAttr(element, MetaConstants.SHRINKVIEW_TOOLBARHEIGHT, null);
		if (toolBarHeight != null && !toolBarHeight.isEmpty()) {
			meta.setToolBarHeight(DefSize.parse(toolBarHeight));
		}else{
			meta.setToolBarHeight(null);
		}
		meta.setToolBarBackColor(DomHelper.readAttr(element, MetaConstants.SHRINKVIEW_TOOLBARBACKCOLOR, null));
	}
}
