package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaImageListItem;

public class MetaImageListItemAction extends BaseDomAction<MetaImageListItem>{

	@Override
	public void load(Document document, Element element, MetaImageListItem meta, int runType) {
		meta.setValue(DomHelper.readAttr(element, MetaConstants.COMMON_VALUE, ""));
		meta.setImage(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaImageListItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_VALUE, meta.getValue(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGE, meta.getImage(), "");
	}

}
