package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;

/**
 * 下拉列表项对象在保存和载入时的动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaDefaultItemAction extends BaseDomAction<MetaDefaultItem> {
	@Override
	public void load(Document document, Element element, MetaDefaultItem meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setValue(DomHelper.readAttr(element, MetaConstants.COMMON_VALUE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaDefaultItem meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VALUE, meta.getValue(), "");
	}
}
