package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaPopView;

public class MetaPopViewAction extends BaseDomAction<MetaPopView> {

	@Override
	public void load(Document document, Element element, MetaPopView meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setArea(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_AREA, "")));
		meta.setPopAnim(DomHelper.readAttr(element, MetaConstants.COMMON_POPANIM, ""));
	}

	@Override
	public void save(Document document, Element element, MetaPopView meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_AREA, DirectionType.toString(meta.getArea()), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_POPANIM, meta.getPopAnim(), "");
	}

}