package com.bokesoft.yes.meta.persist.dom.form;

import com.bokesoft.yigo.common.def.DeliveryClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.FullscreenType;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.common.def.PlatformType;
import com.bokesoft.yigo.common.def.ScreenOrientation;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.MetaForm;

/**
 * 窗口配置对象在载入和保存时的动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaFormAction extends BaseDomAction<MetaForm> {

	@Override
	public void load(Document document, Element element, MetaForm meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setAliasKey(DomHelper.readAttr(element, MetaConstants.COMMON_ALIAS_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, ""));
		meta.setFormType(FormType.parse(DomHelper.readAttr(element, MetaConstants.FORM_FORMTYPE, FormType.STR_Normal)));
		meta.setExtend(DomHelper.readAttr(element, MetaConstants.FORM_EXTEND, ""));
		meta.setAuthenticate(DomHelper.readAttr(element, MetaConstants.AUTHENTICATE_FLAG, true));
		meta.setFormulaCaption(DomHelper.readAttr(element, MetaConstants.COMMON_FORMULA_CAPTION, ""));
		meta.setAbbrCaption(DomHelper.readAttr(element, MetaConstants.COMMON_ABBR_CAPTION, ""));
		meta.setFormulaAbbrCaption(DomHelper.readAttr(element, MetaConstants.COMMON_FORMULA_ABBR_CAPTION, ""));
		meta.setFormDisplay(DomHelper.readAttr(element, MetaConstants.COMMON_FORMDISPLAY, false));
		meta.setInitState(OperationState.parse(DomHelper.readAttr(element, MetaConstants.INIT_STATE, OperationState.STR_EDIT)));
		meta.setViewKey(DomHelper.readAttr(element, MetaConstants.FORM_VIEWKEY, ""));
		meta.setLinkedFormKey(DomHelper.readAttr(element, MetaConstants.FORM_LINKEDFORMKEY, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setPlatform(PlatformType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_PLATFORM, PlatformType.STR_All)));
		meta.setScreenOrientation(ScreenOrientation.parse(DomHelper.readAttr(element, MetaConstants.SCREEN_ORIENTATION, ScreenOrientation.str_unspecified)));
		meta.setHasNavigationBar(DomHelper.readAttr(element, MetaConstants.FORM_HASNAVIGATIONBAR, ""));
		meta.setConfirmClose(DomHelper.readAttr(element, MetaConstants.FORM_CONFIRMCLOSE, true));
		meta.setAnimationType(DomHelper.readAttr(element, MetaConstants.FORM_ANIM, ""));
		String fullScreeTypeStr = DomHelper.readAttr(element, MetaConstants.FORM_FULLSCREENTYPE, null);
		if(fullScreeTypeStr != null){
			meta.setFullScreenType(FullscreenType.parse(fullScreeTypeStr));
		}
		String disableKeyboard = DomHelper.readAttr(element, MetaConstants.MOBILEDEF_DISABLEKEYBOARD, "");
		if(disableKeyboard != null && disableKeyboard.length()>0){
			meta.setDisableKeyboard(TypeConvertor.toBoolean(disableKeyboard));
		}
		meta.setVersion(DomHelper.readAttr(element, MetaConstants.FORM_VERSION, 0));
		meta.setUseVariant(DomHelper.readAttr(element, MetaConstants.FORM_USEVARIANT, false));
		meta.setUserData(DomHelper.readAttr(element, MetaConstants.FORM_USERDATA, ""));
		meta.setMergeToSource(DomHelper.readBool(element, MetaConstants.FORM_MERGETOSOURCE, false));
		meta.setStatusBarColor(DomHelper.readAttr(element, MetaConstants.FORM_STATUSBAR_COLOR, null));
		meta.setOffLine(DomHelper.readAttr(element, MetaConstants.FORM_OFFLINE, false));
		meta.setSourceForm(DomHelper.readAttr(element, MetaConstants.FORM_SOURCEFORM, null));
		meta.setDeliveryClass(DeliveryClass.parse(DomHelper.readAttr(element, MetaConstants.FORM_DELIVERYCLASS, null)));
		meta.setTransFormKey(DomHelper.readAttr(element, MetaConstants.FORM_TRANSFORMKEY, null));
	}

	@Override
	public void save(Document document, Element element, MetaForm meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ALIAS_KEY, meta.getAliasKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN, meta.getCaptionEn(), "");
		DomHelper.writeAttr(element, MetaConstants.FORM_FORMTYPE, FormType.toString(meta.getFormType()), FormType.STR_Normal);
		DomHelper.writeAttr(element, MetaConstants.FORM_EXTEND, meta.getExtend(), "");
		DomHelper.writeAttr(element, MetaConstants.AUTHENTICATE_FLAG, meta.isAuthenticate(), true);
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMULA_CAPTION, meta.getFormulaCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ABBR_CAPTION, meta.getAbbrCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMULA_ABBR_CAPTION, meta.getFormulaAbbrCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMDISPLAY, meta.isFormDisplay(), false);
		DomHelper.writeAttr(element, MetaConstants.INIT_STATE, OperationState.toString(meta.getInitState()), OperationState.STR_EDIT);
		DomHelper.writeAttr(element, MetaConstants.FORM_VIEWKEY, meta.getViewKey(), "");
		DomHelper.writeAttr(element, MetaConstants.FORM_LINKEDFORMKEY, meta.getLinkedFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_PLATFORM, PlatformType.toString(meta.getPlatform()), PlatformType.STR_All);
		DomHelper.writeAttr(element, MetaConstants.SCREEN_ORIENTATION, ScreenOrientation.toString(meta.getScreenOrientation()),ScreenOrientation.str_unspecified);
		DomHelper.writeAttr(element, MetaConstants.FORM_HASNAVIGATIONBAR, meta.isHasNavigationBar(), "");
		DomHelper.writeAttr(element, MetaConstants.FORM_CONFIRMCLOSE, meta.isConfirmClose(), true);
		DomHelper.writeAttr(element, MetaConstants.FORM_ANIM, meta.getAnimationType(), "");
		DomHelper.writeAttr(element, MetaConstants.FORM_FULLSCREENTYPE, FullscreenType.format(meta.getFullScreenType()), "");
		DomHelper.writeAttr(element, MetaConstants.MOBILEDEF_DISABLEKEYBOARD, meta.isDisableKeyboard()== null? "":meta.isDisableKeyboard().toString(), "");
		DomHelper.writeAttr(element, MetaConstants.FORM_VERSION, meta.getVersion(), 0);
		DomHelper.writeAttr(element, MetaConstants.FORM_USEVARIANT, meta.isUseVariant(), false);
		DomHelper.writeAttr(element, MetaConstants.FORM_USERDATA, meta.getUserData(), "");
		DomHelper.writeAttr(element, MetaConstants.FORM_STATUSBAR_COLOR, meta.getStatusBarColor(), null);
		DomHelper.writeAttr(element, MetaConstants.FORM_OFFLINE, meta.isOffLine(), false);
		DomHelper.writeAttr(element, MetaConstants.FORM_MERGETOSOURCE, meta.getMergeToSource(), false);
		DomHelper.writeAttr(element, MetaConstants.FORM_SOURCEFORM, meta.getSourceForm(), null);
		DomHelper.writeAttr(element, MetaConstants.FORM_DELIVERYCLASS, DeliveryClass.toString(meta.getDeliveryClass()), null);
		DomHelper.writeAttr(element, MetaConstants.FORM_TRANSFORMKEY, meta.getTransFormKey(), null);
	}
}
