package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumn;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;

public class MetaExcelColumnAction extends BaseDomAction<MetaExcelColumn> {

	@Override
	public void load(Document document, Element element, MetaExcelColumn meta,
			int runType) {
		meta.setColumnIndex(DomHelper.readAttr(element, MetaExcelTemplateConstants.COLUMN_COLUMNINDEX, -1));
		meta.setWidth(DomHelper.readAttr(element, MetaExcelTemplateConstants.COLUMN_WIDTH, 80));
	}

	@Override
	public void save(Document document, Element element, MetaExcelColumn meta,
			int runType) {
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.COLUMN_COLUMNINDEX, meta.getColumnIndex(), -1);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.COLUMN_WIDTH, meta.getWidth(), 80);
	}
}
