package com.bokesoft.yes.meta.persist.dom.enhance;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.enhance.MetaStartListener;

public class MetaStartListenerAction extends BaseDomAction<MetaStartListener> {

	@Override
	public void load(Document document, Element element, MetaStartListener meta, int runType) {
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.COMMON_IMPL, ""));
	}

	@Override
	public void save(Document document, Element element, MetaStartListener meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_IMPL, meta.getImpl(), "");
	}

}
