package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.ParameterSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;

public class MetaParameterAction extends BaseDomAction<MetaParameter> {

	@Override
	public void load(Document document, Element element, MetaParameter meta, int runType) {
		meta.setFormula(DomHelper.readAttr(element, MetaConstants.QUERY_PARA_FORMULA, ""));
		meta.setSourceType(ParameterSourceType.parse(DomHelper.readAttr(element, MetaConstants.QUERY_PARA_SOURCE_TYPE, ParameterSourceType.STR_FORMULA)));
		meta.setTargetColumn(DomHelper.readAttr(element, MetaConstants.QUERY_PARA_TARGET_COLUMN, ""));
		meta.setTargetTable(DomHelper.readAttr(element, MetaConstants.QUERY_PARA_TARGET_TABLE, ""));
		meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_DATATYPE, "")));
		meta.setFieldKey(DomHelper.readAttr(element, MetaConstants.QUERY_PARA_FIELDKEY, ""));
		meta.setValue(DomHelper.readAttr(element, MetaConstants.QUERY_PARA_VALUE, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaParameter meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.QUERY_PARA_FORMULA, meta.getFormula(), "");
		DomHelper.writeAttr(element, MetaConstants.QUERY_PARA_SOURCE_TYPE, ParameterSourceType.format(meta.getSourceType()), ParameterSourceType.STR_FORMULA);
		DomHelper.writeAttr(element, MetaConstants.QUERY_PARA_TARGET_COLUMN, meta.getTargetColumn(), "");
		DomHelper.writeAttr(element, MetaConstants.QUERY_PARA_TARGET_TABLE, meta.getTargetTable(), "");
		if (meta.getTargetColumn() == null || meta.getTargetColumn().length() == 0)
			DomHelper.writeAttr(element, MetaConstants.COLUMN_DATATYPE, DataType.toString(meta.getDataType()), "");
		DomHelper.writeAttr(element, MetaConstants.QUERY_PARA_FIELDKEY, meta.getFieldKey(), "");
		DomHelper.writeAttr(element, MetaConstants.QUERY_PARA_VALUE, meta.getValue(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
	}

}
