package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaLayer;

public class MetaLayerAction extends BaseDomAction<MetaLayer> {

	@Override
	public void load(Document document, Element element, MetaLayer meta, int runType) {
		meta.setItemKey(DomHelper.readAttr(element,
				MetaConstants.LAYER_ITEMKEY, ""));
		meta.setRelation(MetaLayer.parseRelation(DomHelper.readAttr(element,
				MetaConstants.LAYER_RELATION, "")));
		meta.setTableKey(DomHelper.readAttr(element,
				MetaConstants.LAYER_TABLEKEY, ""));
		meta.setColumnKey(DomHelper.readAttr(element,
				MetaConstants.LAYER_COLUMNKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaLayer meta, int runType) {	
		
		DomHelper.writeAttr(element, MetaConstants.LAYER_ITEMKEY,
				meta.getItemKey(), "");
		DomHelper.writeAttr(element, MetaConstants.LAYER_RELATION,
				MetaLayer.getRelationStr(meta.getRelation()), "");
		DomHelper.writeAttr(element, MetaConstants.LAYER_TABLEKEY,
				meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.LAYER_COLUMNKEY,
				meta.getColumnKey(), "");
	}

}

