package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;

/**
 * 数据源对象的载入和保存时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaDataSourceAction extends BaseDomAction<MetaDataSource> {

	@Override
	public void load(Document document, Element element, MetaDataSource meta, int runType) {
		meta.setRefObjectKey(DomHelper.readAttr(element, MetaConstants.DATASOURCE_REFOBJECTKEY, ""));
		meta.setRefTableKey(DomHelper.readAttr(element, MetaConstants.DATASOURCE_REFTABLEKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaDataSource meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DATASOURCE_REFOBJECTKEY, meta.getRefObjectKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATASOURCE_REFTABLEKEY, meta.getRefTableKey(), "");
	}
}
