package com.bokesoft.yes.meta.persist.dom.datamigration;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTable;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTableCollection;
import com.bokesoft.yigo.meta.datamigration.MetaDMTargetField;
import com.bokesoft.yigo.meta.datamigration.MetaDMTargetTable;
import com.bokesoft.yigo.meta.datamigration.MetaDMTargetTableCollection;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.error.MetaDataMigrationErrorInfo;
import com.bokesoft.yigo.meta.datamigration.error.MetaDataMigrationErrorInfoCollection;

public class MetaDataMigrationActionMap extends MetaActionMap {
	private MetaDataMigrationActionMap() {
		super();
	}
	
	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
				{ MetaDataMigration.TAG_NAME, new MetaDataMigrationAction() },
				{ MetaDMSourceTableCollection.TAG_NAME, new MetaDMSourceTableCollectionAction() },
				{ MetaDMSourceTable.TAG_NAME, new MetaDMSourceTableAction() },
				{ MetaDMSourceField.TAG_NAME, new MetaDMSourceFieldAction() },
				{ MetaDMTargetTableCollection.TAG_NAME, new MetaDMTargetTableCollectionAction() },
				{ MetaDMTargetTable.TAG_NAME, new MetaDMTargetTableAction() },
				{ MetaDMTargetField.TAG_NAME, new MetaDMTargetFieldAction() },
				{ MetaDataMigrationErrorInfoCollection.TAG_NAME, new MetaDataMigrationErrorInfoCollectionAction()},
				{ MetaDataMigrationErrorInfo.TAG_NAME, new MetaDataMigrationErrorInfoAction()}
		};
	}

	private static MetaDataMigrationActionMap instance = null;
	public static MetaDataMigrationActionMap getInstance() {
		if ( instance == null ) {
			instance = new MetaDataMigrationActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
}
