package com.bokesoft.yes.meta.persist.dom.datamigration;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamigration.MetaDMConstants;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTableCollection;

public class MetaDMSourceTableCollectionAction extends BaseDomAction<MetaDMSourceTableCollection> {

	@Override
	public void load(Document document, Element element,
			MetaDMSourceTableCollection meta, int runType) {
		meta.setX(DomHelper.readAttr(element, MetaDMConstants.X, -1));
		meta.setY(DomHelper.readAttr(element, MetaDMConstants.Y, -1));
		meta.setWidth(DomHelper.readAttr(element, MetaDMConstants.WIDTH, -1));
		meta.setHeight(DomHelper.readAttr(element, MetaDMConstants.HEIGHT, -1));
	}

	@Override
	public void save(Document document, Element element,
			MetaDMSourceTableCollection meta, int runType) {
		DomHelper.writeAttr(element, MetaDMConstants.X, meta.getX(), -1);
		DomHelper.writeAttr(element, MetaDMConstants.Y, meta.getY(), -1);
		DomHelper.writeAttr(element, MetaDMConstants.WIDTH, meta.getWidth(), -1);
		DomHelper.writeAttr(element, MetaDMConstants.HEIGHT, meta.getHeight(), -1);
	}

}
