package com.bokesoft.yes.meta.persist.dom.datamap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTable;

public class MetaSourceTableAction extends BaseDomAction<MetaSourceTable> {

	@Override
	public void load(Document document, Element element, MetaSourceTable meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setPrimary(DomHelper.readAttr(element, MetaMapConstants.TABLE_IS_PRIMARY, false));
		meta.setTargetTableKey(DomHelper.readAttr(element, MetaMapConstants.TABLE_TARGET_TABLE, ""));
		meta.setCondition(DomHelper.readAttr(element, MetaMapConstants.FIELD_CONDITION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaSourceTable meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.TABLE_IS_PRIMARY, meta.isPrimary(), false);
		DomHelper.writeAttr(element, MetaMapConstants.TABLE_TARGET_TABLE, meta.getTargetTableKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_CONDITION, meta.getCondition(), "");
	}

}
