package com.bokesoft.yes.meta.persist.dom.commondef.resource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconDisplayMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSource;

public class MetaIconSourceAction extends BaseDomAction<MetaIconSource> {

	@Override
	public void load(Document document, Element element, MetaIconSource meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setSource(DomHelper.readAttr(element, MetaConstants.ICON_SOURCE_SOURCE, ""));
		meta.setScene(DomHelper.readAttr(element, MetaConstants.ICON_SOURCE_SCENE, null));
		String displayMode = DomHelper.readAttr(element, MetaConstants.ICON_DISPLAY_MODE, null);
		if (displayMode != null) {
			meta.setDisplayMode(IconDisplayMode.parse(displayMode));
		}
	}

	@Override
	public void save(Document document, Element element, MetaIconSource meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.ICON_SOURCE_SOURCE, meta.getSource(), "");
		DomHelper.writeAttr(element, MetaConstants.ICON_DISPLAY_MODE, IconDisplayMode.format(meta.getDisplayMode()), "");
		DomHelper.writeAttr(element, MetaConstants.ICON_SOURCE_SCENE, meta.getScene(), "");
	}
}
