package com.bokesoft.yes.meta.persist.dom.commondef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconDisplayMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;

/**
 * 窗口操作的集合对象在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaOperationCollectionExtAction extends BaseDomAction<MetaOperationCollection> {

	@Override
	public void load(Document document, Element element,
			MetaOperationCollection meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, null));
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, null));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, null));
		meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, null));
		meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, null));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, null));
		meta.setSelfDisable(DomHelper.readBool(element, MetaConstants.OPERATION_COLLECTION_SELFDISABLE, null));
		meta.setCssClass(DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, null));
		meta.setIconCode(DomHelper.readAttr(element, MetaConstants.COMMON_ICON_CODE, null));
		String displayMode = DomHelper.readAttr(element, MetaConstants.ICON_DISPLAY_MODE, null);
		if (displayMode != null) {
			meta.setDisplayMode(IconDisplayMode.parse(displayMode));
		}
	}

	@Override
	public void save(Document document, Element element,
			MetaOperationCollection meta, int runType) {

	}

}
