package com.bokesoft.yes.meta.persist.dom.commondef;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.MetaDefaultItemAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.MetaListBoxItemCollectionAction;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaDomainCollection;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.domain.MetaItemKeyCollection;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;

public class MetaDomainDefActionMap extends MetaActionMap {
    private MetaDomainDefActionMap() {
        super();
    }

    @Override
    protected Object[][] getActionLookupTable() {
        return new Object[][] {
                { MetaDomainDef.TAG_NAME, new MetaDomainDefAction() },
                { MetaDomainCollection.TAG_NAME, new MetaDomainCollectionAction() },
                { MetaDomain.TAG_NAME, new MetaDomainAction() },
                { MetaDomain.TAG_NAME, new MetaDomainAction() },
                { MetaListBoxItemCollection.TAG_NAME, new MetaListBoxItemCollectionAction() },
                { MetaDefaultItem.TAG_NAME, new MetaDefaultItemAction() },
                { MetaItemKeyCollection.TAG_NAME, new MetaItemKeyCollectionAction() },
                { MetaConstants.COMBOBOX_FORMULAITEMS, new MetaBaseScriptAction<>() },
        };
    }

    private static MetaDomainDefActionMap instance = null;
    public static MetaDomainDefActionMap getInstance() {
        if ( instance == null ) {
            instance = new MetaDomainDefActionMap();
        }
        return instance;
    }

    @Override
    protected Object[][] getHostActionLookupTable() {
        return null;
    }
}
