package com.bokesoft.yes.meta.persist.dom.commondef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;

public class MetaDataElementAction extends BaseDomAction<MetaDataElement> {

	@Override
	public void load(Document document, Element element,
			MetaDataElement meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
		meta.setDomainKey(DomHelper.readAttr(element, MetaConstants.DATAELEMENT_DOMAINKEY, null));
		String dataType = DomHelper.readAttr(element, MetaConstants.DATAELEMENT_DATATYPE, null);
		if(dataType != null) {
			Integer dt = DataType.parse(dataType);
			meta.setDataType(dt);
			Integer defaultLength = dt == DataType.STRING ? 255 : null;
			meta.setLength(DomHelper.readInt(element, MetaConstants.DATAELEMENT_LENGTH, defaultLength));
			Integer defaultPrecision = dt == DataType.NUMERIC ? 16 : null;
			meta.setPrecision(DomHelper.readInt(element, MetaConstants.DATAELEMENT_PRECISION, defaultPrecision));
			Integer defaultScale = dt == DataType.NUMERIC ? 2 : null;
			meta.setScale(DomHelper.readInt(element, MetaConstants.DATAELEMENT_SCALE, defaultScale));
		}
		
		meta.setParamID(DomHelper.readAttr(element, MetaConstants.DATAELEMENT_PARAMID, null));
		meta.setDefaultCaption(DomHelper.readAttr(element, MetaConstants.DATAELEMENT_DEFAULTCAPTION, null));
		meta.setDataDiffLog(DomHelper.readBool(element, MetaConstants.DATAELEMENT_DATADIFFLOG, null));
		meta.setNoHistory(DomHelper.readBool(element, MetaConstants.DATAELEMENT_NOHISTORY, null));
	}

	@Override
	public void save(Document document, Element element,
			MetaDataElement meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		String domainKey = meta.getDomainKey();
		if(domainKey == null || domainKey.isEmpty()) {
			DomHelper.writeAttr(element, MetaConstants.DATAELEMENT_DATATYPE, DataType.toString(meta.getDataType()), "");
			Integer dt = meta.getDataType() == null ? -1 : meta.getDataType();
			int length = dt == DataType.STRING ? meta.getLength() : 0;
			int defaultLength = dt == DataType.STRING ? 255 : 0;
			DomHelper.writeAttr(element, MetaConstants.DATAELEMENT_LENGTH, length, defaultLength);
			if(dt == DataType.NUMERIC){
				int precision = dt == DataType.NUMERIC ? meta.getPrecision() : 0;
				element.setAttribute(MetaConstants.DATAELEMENT_PRECISION, Integer.toString(precision));
				int scale = dt == DataType.NUMERIC ? meta.getScale() : 0;
				element.setAttribute(MetaConstants.DATAELEMENT_SCALE, Integer.toString(scale));
			} else if (dt == DataType.INT || dt == DataType.LONG) {
				// 当原来是numeric类型然后转换成long/int 类型之后，原来的precision、 scale还会保留
				element.removeAttribute(MetaConstants.DATAELEMENT_PRECISION);
				element.removeAttribute(MetaConstants.DATAELEMENT_SCALE);
			}
		}else {
			DomHelper.writeAttr(element, MetaConstants.DATAELEMENT_DOMAINKEY, domainKey, null);
		}
		DomHelper.writeAttr(element, MetaConstants.DATAELEMENT_PARAMID, meta.getParamID(), null);
		DomHelper.writeAttr(element, MetaConstants.DATAELEMENT_DEFAULTCAPTION, meta.getDefaultCaption(), null);
		DomHelper.writeAttr(element, MetaConstants.DATAELEMENT_DATADIFFLOG, meta.getDataDiffLog(), null);
		DomHelper.writeAttr(element, MetaConstants.DATAELEMENT_NOHISTORY, meta.getNoHistory(), null);
	}

}
