package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaConditionTarget;

public class MetaConditionTargetAction extends BaseDomAction<MetaConditionTarget> {

	@Override
	public void load(Document document, Element element,
			MetaConditionTarget meta, int runType) {
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
		meta.setColumnKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_COLUMNKEY, ""));
		meta.setTarget(DomHelper.readAttr(element, MetaConstants.CONDITION_TARGET, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaConditionTarget meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_TARGET, meta.getTarget(), "");
	}
}
