package com.bokesoft.yes.meta.persist.dom.charging;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.charging.MetaChargingObject;
import com.bokesoft.yigo.meta.intf.IMetaProject;

/**
 * MetaChargingObjectProfile定义计费对象的摘要属性
 * @author wangyh
 *
 */
public class MetaChargingObjectProfile extends KeyPairMetaObject {
	/** 工程 */
	private IMetaProject project = null;
	/** 资源 */
	private String resource = "";
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 计费对象 */
	private MetaChargingObject chargingObject = null;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	public static final String TAG_NAME = "ChargingObject";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置工程
	 * @param project 工程
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}
	
	/**
	 * 取得工程
	 * @return 工程
	 */
	public IMetaProject getProject() {
		return this.project;
	}
	
	/**
	 * 设置资源
	 * @param resource 资源
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}
	
	/**
	 * 取得资源
	 * @return 资源
	 */
	public String getResource() {
		return this.resource;
	}
	
	/**
	 * 设置计费对象
	 * @param chargingObject 计费对象
	 */
	public void setChargingObject(MetaChargingObject chargingObject) {
		this.chargingObject = chargingObject;
	}
	
	/**
	 * 取得计费对象
	 * @return 计费对象
	 */
	public MetaChargingObject getChargingObject() {
		return this.chargingObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChargingObjectProfile();
	}
}
