package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.bpm.action.MetaBPMElementAction;
import com.bokesoft.yigo.common.def.BPMLockType;
import com.bokesoft.yigo.common.def.DocRefType;
import com.bokesoft.yigo.common.def.NodePattern;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;

public class MetaNodeAction<T extends MetaNode> extends MetaBPMElementAction<T> {

	@Override
	public void load(Document doc, Element node, T meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setBPMKey(DomHelper.readAttr(node, BPMConstants.NODE_PROCESSKEY, ""));
		meta.setInUse(DomHelper.readAttr(node, BPMConstants.NODE_INUSE, true));
		meta.setTag(DomHelper.readAttr(node, BPMConstants.NODE_TAG, ""));
		meta.setUserData(DomHelper.readAttr(node, BPMConstants.NODE_USER_DATA, ""));
		meta.setWorkitemRevoke(DomHelper.readAttr(node, BPMConstants.NODE_WORKITEM_REVOKE, true));
		meta.setRetreatCaption(DomHelper.readAttr(node, BPMConstants.RETREAT_CAPTION, ""));
		meta.setRefDocKey(DomHelper.readAttr(node, BPMConstants.NODE_REF_DOC_KEY, ""));
		meta.setRefType(DocRefType.parse(DomHelper.readAttr(node, BPMConstants.NODE_REF_TYPE, DocRefType.STR_NEW)));
		meta.setTemplateKey(DomHelper.readAttr(node, BPMConstants.NODE_TEMPLATEKEY, ""));
		meta.setRevokeTrigger(DomHelper.readAttr(node, BPMConstants.NODE_REVOKE_TRIGGER, ""));
		meta.setPattern(DomHelper.readAttr(node,BPMConstants.NODE_PATTERN , NodePattern.STR_NORMAL));
		meta.setRevokeCondition(DomHelper.readAttr(node,BPMConstants.NODE_REVOKE_CONDITION , ""));
		meta.setStop(DomHelper.readAttr(node,BPMConstants.NODE_STOP , false));
		meta.setBPMState(DomHelper.readAttr(node, BPMConstants.NODE_BPMSTATE, -1));
		meta.setSync(DomHelper.readAttr(node, BPMConstants.ISSYNC, false));
		meta.setLockWorkitem(BPMLockType.parse(DomHelper.readAttr(node, BPMConstants.LOCK_WORKITEM, BPMLockType.STR_NONE)));
		meta.setExcluded(DomHelper.readAttr(node, BPMConstants.NODE_EXCLUDED, false));
	}

	@Override
	public void save(Document doc, Element node, T meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_PROCESSKEY, meta.getBPMKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_INUSE, meta.isInUse(), true);
		DomHelper.writeAttr(node, BPMConstants.NODE_TAG, meta.getTag(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_USER_DATA, meta.getUserData(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_WORKITEM_REVOKE, meta.isWorkitemRevoke(), true);
		DomHelper.writeAttr(node, BPMConstants.RETREAT_CAPTION, meta.getRetreatCaption(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_TEMPLATEKEY, meta.getTemplateKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_REVOKE_TRIGGER, meta.getRevokeTrigger(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_REF_DOC_KEY, meta.getRefDocKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_REF_TYPE, DocRefType.toString(meta.getRefType()), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_PATTERN, meta.getPattern(), NodePattern.STR_NORMAL);
		DomHelper.writeAttr(node, BPMConstants.NODE_REVOKE_CONDITION, meta.getRevokeCondition(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_STOP, meta.getStop(), false);
		DomHelper.writeAttr(node, BPMConstants.NODE_BPMSTATE, meta.getBPMState(), -1);
		DomHelper.writeAttr(node, BPMConstants.ISSYNC, meta.isSync(), false);
		DomHelper.writeAttr(node, BPMConstants.LOCK_WORKITEM, meta.getLockWorkitem(), BPMLockType.NONE);
		DomHelper.writeAttr(node, BPMConstants.NODE_EXCLUDED, meta.isExcluded(), false);
	}
}
