package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBegin;

public class MetaBeginAction extends MetaNodeAction<MetaBegin> {

	@Override
	public void load(Document doc, Element node, MetaBegin meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setStatus(DomHelper.readAttr(node, BPMConstants.NODE_STATUS, ""));
	}
	
	@Override
	public void save (Document doc, Element node, MetaBegin meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_STATUS, meta.getStatus(), "");
	}
}
