package com.bokesoft.yes.meta.persist.dom.bpm.action.message;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.message.MetaConsumer;

public class MetaConsumerAction extends BaseDomAction<MetaConsumer> {

	@Override
	public void load(Document document, Element element, MetaConsumer meta, int runType) {
		meta.setIsReceiveMessage(DomHelper.readAttr(element, BPMConstants.NODE_IS_RECEIVE_MESSAGE, false));
		meta.setReceiveHandleImpl(DomHelper.readAttr(element, BPMConstants.NODE_RECEIVE_HANDLE_IMPL, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaConsumer meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.NODE_IS_RECEIVE_MESSAGE, meta.isReceiveMessage(), false);
		DomHelper.writeAttr(element, BPMConstants.NODE_RECEIVE_HANDLE_IMPL, meta.getReceiveHandleImpl(), "");
	}
}
