package com.bokesoft.yes.meta.persist.dom.bpm.action.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.extend.MetaExtendItem;

public class MetaExtendItemAction extends MetaItemsAction<MetaExtendItem> {

	@Override
	public void load(Document document, Element element, MetaExtendItem meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setPath(DomHelper.readAttr(element, BPMConstants.PARTICIPATOR_PATH, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaExtendItem meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, BPMConstants.PARTICIPATOR_PATH, meta.getPath(), "");
	}
}
