package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.processadministrator.MetaDictAdministrator;

public class MetaDictAdministratorAction extends BaseDomAction<MetaDictAdministrator> {

	@Override
	public void load(Document document, Element element, MetaDictAdministrator meta, int runType) {
		meta.setDictionaryKey(DomHelper.readAttr(element, BPMConstants.PARTICIPATOR_DICTIONARYKEY, ""));
		meta.setItemID(DomHelper.readAttr(element, BPMConstants.PARTICIPATOR_ITEMID, ""));
		meta.setCode(DomHelper.readAttr(element, BPMConstants.PARTICIPATOR_CODE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaDictAdministrator meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.PARTICIPATOR_DICTIONARYKEY, meta.getDictionaryKey(), "");
		DomHelper.writeAttr(element, BPMConstants.PARTICIPATOR_ITEMID, meta.getItemID(), "");
		DomHelper.writeAttr(element, BPMConstants.PARTICIPATOR_CODE, meta.getCode(), "");
	}

}
