package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attachment.AttachmentType;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachment;

public class MetaAttachmentAction extends BaseDomAction<MetaAttachment> {

	@Override
	public void load(Document document, Element element, MetaAttachment meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, BPMConstants.COMMON_KEY, ""));
		meta.setType(AttachmentType.parse(DomHelper.readAttr(element, BPMConstants.BPM_TYPE, AttachmentType.BILL_TAG)));
		meta.setCaption(DomHelper.readAttr(element, BPMConstants.COMMON_CAPTION, ""));
		meta.setPara(DomHelper.readAttr(element, BPMConstants.ATTACHMENT_PARA, ""));
	}

	@Override
	public void save(Document document, Element element, MetaAttachment meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, BPMConstants.BPM_TYPE, AttachmentType.toString(meta.getType()), AttachmentType.BILL_TAG);
		DomHelper.writeAttr(element, BPMConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, BPMConstants.ATTACHMENT_PARA, meta.getPara(), "");
	}

}
