package com.bokesoft.yes.meta.persist.dom.bpm.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;

public class MetaBPMDeployInfoAction extends BaseDomAction<MetaProcessDeployInfo> {

	@Override
	public void load(Document doc, Element node, MetaProcessDeployInfo meta, int runType) {
		meta.setInitDate(DomHelper.readAttr(node,
				BPMConstants.COMMON_INIT_DATE, ""));
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
		meta.setVersion(DomHelper.readAttr(node,
				BPMConstants.COMMON_VERSION, 1));
	}

	@Override
	public void save(Document doc, Element node, MetaProcessDeployInfo meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.COMMON_INIT_DATE,
				meta.getInitDate(), "");
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(),
				"");
		DomHelper.writeAttr(node, BPMConstants.COMMON_VERSION,
				meta.getVersion(), 1);
	}

}
