package com.bokesoft.yes.meta.persist.dom;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

import com.bokesoft.yes.meta.persist.dom.dataobject.MetaCheckRuleAction;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRule;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRuleCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;

public abstract class AbstractLoad implements IMetaEnv {
    protected IMetaActionMap actionMap = null;
    protected IMetaActionMap extActionMap = null;
    protected AbstractMetaObject rootMetaObject = null;
    protected int runType = AppRunType.App;
    protected String resource = null;

    public AbstractLoad(int runType) {
        this.runType = runType;
        this.actionMap = this.getActionMap();
        this.extActionMap = this.getExtendActionMap();
    }

    public void load(IMetaResolver resolver, String resource) throws Exception {
        this.resource = resource;
        InputStream in = resolver.read(resource, -1);
        try {
            if (in == null) {
                rootMetaObject = null;
            } else {
                Document document = DomHelper.createDocument(in);
                load(document);
            }
        } catch (Exception e) {
            e.printStackTrace();
            LogSvr.getInstance().error(resolver.getPath(resource), e);
            throw e;
        } finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void load(InputStream in) throws Throwable {
        Document document = DomHelper.createDocument(in);
        load(document);
    }

    /**
     * 载入数据对象
     *
     * @throws MetaException
     */
    public void load(Document document) throws MetaException {
        Element rootElement = document.getDocumentElement();
        rootMetaObject = newRootMetaObject(rootElement);
        if (rootMetaObject.needPreLoad()) {
            rootMetaObject.preProcessMetaObject(this, document, rootElement, false, runType);
        }

        processActionMap(rootElement);
        loadMetaObject(document, null, rootElement, rootMetaObject);
    }

    @Override
    public boolean checkExtend(AbstractMetaObject meta,Object node) {
        return false;
    }

    private void loadMetaObject(Document document, AbstractMetaObject parent, Element element, AbstractMetaObject meta) throws MetaException {
        if (parent instanceof MetaCheckRuleCollection && meta instanceof MetaCheckRule) {
            MetaCheckRuleAction action = new MetaCheckRuleAction();
            // 加载
            if ( !meta.needPreLoad() ) {
                action.process(this, document, element, (MetaCheckRule) meta, false, runType);
            }
        } else {
            String tagName = element.getTagName();
            IMetaAction<AbstractMetaObject> action = this.getAction(meta, element);
            if( action == null && parent != null ) {
                action = this.getAction(parent.getTagName(), tagName);
            }
            if( action == null ) {
                throw new MetaException(MetaException.NO_ACTION_DEFINED, "No action defined for " + tagName);
            }
            // 加载
            if ( !meta.needPreLoad() ) {
                action.process(this, document, element, meta, false, runType);
            }
        }

        List<Element> childNodeList = DomHelper.getChildList(element);
        Element childElement = null;
        Iterator<Element> itChildElement = childNodeList.iterator();
        while (itChildElement.hasNext()) {
            childElement = itChildElement.next();

            AbstractMetaObject childMetaObject = meta.createChildMetaObject(
                    this, document, childElement, childElement.getTagName(), false, runType);

            if ( childMetaObject == null ) {
                throw new MetaException(MetaException.NO_CREATOR_DEFINED, "file " + this.resource + " " +
                        element.getTagName() + " no creator defined for child element " + childElement.getTagName());
            }

            //递归加载子项
            loadMetaObject(document, meta, childElement, childMetaObject);
        }
    }

    /**
     * 获得根元素的配置对象
     *
     * @return 配置对象
     */
    public AbstractMetaObject getRootMetaObject() {
        return rootMetaObject;
    }

    /**
     * 新建一个根元素配置对象
     * @param root 根节点
     * @return 配置对象
     */
    protected abstract AbstractMetaObject newRootMetaObject(Element root);

    /**
     * 处理事件映射，用于在根节点之后决定如何载入内容
     *
     * @param root
     *            根节点
     */
    protected void processActionMap(Element root) {

    }

    /**
     * 获取一个二维数组：此二维表存储了所有数据对象的标签名和操作数据对象的动作对象

     * <pre>
     * 第一列：对象的标签名
     * 第二列：数据对象的动作
     * </pre>

     *
     * @return 二维数据数组
     */
    protected abstract IMetaActionMap getActionMap();

    /**
     * 获取继承的动作对象,目前只有表单继承
     * @return
     */
    protected IMetaActionMap getExtendActionMap() {
        return null;
    }

    public Object prepare(AbstractMetaObject meta, Object node) {
        return null;
    }

    /**
     * 获取该标签的动作对象,如果需要继承处理,获取继承的动作对象
     */
    @Override
    public IMetaAction<AbstractMetaObject> getAction(AbstractMetaObject meta, Object node) {
        IMetaAction<AbstractMetaObject> action = null;
        String tagName = meta.getTagName();
        if( extActionMap != null && checkExtend(meta, node) ) {
            action = extActionMap.getAction(tagName);
        }
        if( action == null ) {
            action = this.actionMap.getAction(tagName);
        }
        return action;
    }

    private IMetaAction<AbstractMetaObject> getAction(String parentTagName, String tagName) {
        return this.actionMap.getAction(parentTagName, tagName);
    }

    public String getResource() {
        return resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }


}
