package com.bokesoft.yes.meta.datamigration.calculate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.DataGroupGranularity;
import com.bokesoft.yigo.common.def.DataSplitType;
import com.bokesoft.yigo.common.def.MigrationAttributeDef;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

/**
 *	分析迁移数据源的字段信息
 *
 */
public class MigrationDatabjectParas implements Serializable {
	private MetaColumn periodColumn = null;

	private int periodGranularity = -1;

	private String periodImpl = null;

	private ArrayList<MetaColumn> groupColumnWithNoPeriodList = new ArrayList<MetaColumn>();

	private ArrayList<MetaColumn> groupColumnList = new ArrayList<MetaColumn>();

	private ArrayList<MetaColumn> dataColumnList = new ArrayList<MetaColumn>();
	
	private ArrayList<MetaColumn> periodSplitColumnList = new ArrayList<MetaColumn>();
	
	private Map<String, MetaColumn> periodBeginColumnMap = new HashMap<String, MetaColumn>();
	
	private Map<String, MetaColumn> periodEndColumnMap = new HashMap<String, MetaColumn>();
	// 记录期末字段和源字段的对应关系，用于新增数据时，将发生额插入期末字段中
	private Map<String, MetaColumn> periodEndToSrcFieldMap = new HashMap<String, MetaColumn>();
	
	public MigrationDatabjectParas(IMetaFactory metaFactory, MetaDataObject migrationDataObject) throws Throwable {
		String dataObjectKey = migrationDataObject.getKey();
		MetaTable migrationTable = migrationDataObject.getTableCollection().get(0);

		for (MetaColumn column : migrationTable) {
			if (column.isGroup()) {
				// 期间字段只能有一个
				if (column.getGroupType() == DataGroupGranularity.Period) {
					if (periodColumn != null)
						throw new MetaException(MetaException.MIGRATION_PERIOD_ERROR, SimpleStringFormat.format(
								StringTable.getString(null, "", StringTable.MigrationPeriodError), dataObjectKey));
					periodColumn = column;
					periodGranularity = column.getPeriodGranularity();
					periodImpl = column.getPeriodImpl();
				} else {
					groupColumnWithNoPeriodList.add(column);
				}
			} else {
				if (column.getSplitType() == DataSplitType.Period) {
					periodSplitColumnList.add(column);
				}
				dataColumnList.add(column);
			}
		}
		
		for(MetaColumn column : periodSplitColumnList){
			String key = column.getKey();
			String begin = key + MigrationAttributeDef.BEGIN_BALANCE_POSTFIX;
			String end = key + MigrationAttributeDef.END_BALANCE_POSTFIX;

			periodBeginColumnMap.put(key, migrationTable.get(begin));
			periodEndColumnMap.put(key, migrationTable.get(end));
			periodEndToSrcFieldMap.put(end, column);
		}
		
		
		groupColumnList.addAll(groupColumnWithNoPeriodList);
		if (periodColumn != null)
			groupColumnList.add(periodColumn);
	}

	/**
	 * 获取期间字段
	 * @return 返回期间字段
	 */
	public MetaColumn getPeriodColumn() {
		return periodColumn;
	}

	/**
	 * 获取期间粒度
	 * @return 返回期间粒度
	 */
	public int getPeriodGranularity() {
		return periodGranularity;
	}

	/**
	 * 获取期间二次开发域名
	 * @return 返回期间二次开发域名
	 */
	public String getPeriodImpl() {
		return periodImpl;
	}

	/**
	 * 获取不包括期间字段的分组字段集合
	 * @return 返回不包括期间字段的分组字段集合
	 */
	public ArrayList<MetaColumn> getGroupColumnWithNoPeriodList() {
		return groupColumnWithNoPeriodList;
	}

	/**
	 * 获取包括期间字段的分组字段集合
	 * @return 返回包括期间字段的分组字段集合
	 */
	public ArrayList<MetaColumn> getGroupColumnList() {
		return groupColumnList;
	}

	/**
	 * 获取数据字段
	 * @return 返回数据字段集合
	 */
	public ArrayList<MetaColumn> getDataColumnList() {
		return dataColumnList;
	}
	
	/**
	 * 获取期间拆分字段
	 * @return 返回期间拆分字段集合
	 */
	public ArrayList<MetaColumn> getPeriodSplitColumnList() {
		return periodSplitColumnList;
	}
	
	/**
	 * 获取期间字段对应的期初字段
	 * @param key 期间字段key
	 * @return
	 */
	public MetaColumn getPeriodBeginColumn(String key) {
		return periodBeginColumnMap.get(key);
	}
	
	/**
	 * 获取期间字段对应的期末字段
	 * @param key 期间字段key
	 * @return
	 */
	public MetaColumn getPeriodEndColumn(String key) {
		return periodEndColumnMap.get(key);
	}
	
	/**
	 * 获取期末字段字段对应的源字段
	 * @param key 期末字段key
	 * @return
	 */
	public MetaColumn getDataFieldByPeriodEndField(String key) {
		return periodEndToSrcFieldMap.get(key);
	}
}
