package com.bokesoft.yes.meta.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.strings.MetaStringTable;

public class AppMetaUtil {
	
	
	/**
	 * 获取参数组定义
	 * @param metaFactory 配置工厂
	 * @param groupKey 参数组标识
	 * @return 参数组定义
	 * @throws Throwable 可能抛出的异常
	 */
	public static MetaParaGroup getParaGroup(IMetaFactory metaFactory, String groupKey) throws Throwable {
		return metaFactory.getParaTable().get(groupKey);
	}
	
	/**
	 * 获取状态项集合
	 * @param metaFactory 配置工厂
	 * @param formKey 表单标识
	 * @return 状态项集合
	 * @throws Throwable 可能抛出的异常
	 */
	public static MetaStatusCollection getStatusCollection(IMetaFactory metaFactory,MetaForm metaForm) throws Throwable {
		MetaDataObject dataObject = null;
		MetaDataSource dataSource = metaForm.getDataSource();
		if( dataSource != null ) {
			dataObject = dataSource.getDataObject();
		}
		if( dataObject == null ) {
			return getStatusCollection(metaFactory, metaForm.getProjectKey());
		} 
		return getStatusCollection(metaFactory,dataObject);
	}
	
	/**
	 * 获取状态集合
	 * @param metaFactory 配置工厂
	 * @param dataObject 元数据对象
	 * @return 状态集合
	 * @throws Throwable 可能抛出的异常
	 */
	public static MetaStatusCollection getStatusCollection(IMetaFactory metaFactory,MetaDataObject dataObject) throws Throwable {
		if( dataObject == null )
			return null;
		MetaStatusCollection statusCollection = dataObject.getStatusCollection();
		if (statusCollection == null || statusCollection.size() == 0) {
			String relateObjectKey = dataObject.getRelateObjectKey();
			if ( relateObjectKey != null && !relateObjectKey.isEmpty() ) {
				MetaDataObject relateDataObject = metaFactory.getDataObject(relateObjectKey);
				if ( relateDataObject != null ) {
					statusCollection = relateDataObject.getStatusCollection();
				}
			}
			if ( statusCollection == null || statusCollection.size() == 0 ) {
				return getStatusCollection(metaFactory, dataObject.getProjectKey());
			}
		}
		return statusCollection;
	}
	
	private static MetaStatusCollection getStatusCollection(IMetaFactory metaFactory,String projectKey) throws Throwable {
		MetaStatusCollection statusCollection = null;
		MetaCommonDef commonDef = metaFactory.getCommonDef(projectKey);
		if (commonDef != null) {
			statusCollection = commonDef.getStatusCollection();
		}
		if (statusCollection == null || statusCollection.size() == 0) {
			commonDef = metaFactory.getCommonDef("");
			if (commonDef != null) {
				statusCollection = commonDef.getStatusCollection();
			}
		}
		return statusCollection;
	}
	
	/**
	 * 获取一个数据表对应的子表集合
	 * @param metaForm 元表单
	 * @param tableKey 表名
	 * @return 子表集合
	 * @throws Throwable 可能抛出的异常
	 */
	public static List<MetaTable> getChildrenTable(MetaForm metaForm,String tableKey) throws Throwable {
		List<MetaTable> tables = new ArrayList<MetaTable>();
		MetaDataSource dataSource = metaForm.getDataSource();
		if (dataSource == null) {
			return tables;
		}
		
		MetaDataObject metaDataObject = dataSource.getDataObject();
		
		MetaTableCollection metaTableCollection = null;
		if (metaDataObject != null) {
			metaTableCollection = metaDataObject.getTableCollection();
		}
		
		MetaTable metaTable = null;
		if( metaTableCollection != null ) {
			Iterator<MetaTable> it = metaTableCollection.iterator();
			while( it.hasNext() ) {
				metaTable = it.next();
				if( metaTable.getParentKey() != null &&
						metaTable.getParentKey().equals(tableKey) ) 
					tables.add(metaTable);
			}
		}
		return tables;
	}
	
	/**
	 * 获取绑定的元数据表
	 * @param metaFactory 配置工厂
	 * @param metaForm 元表单
	 * @param tableKey 表名
	 * @return 元数据表
	 * @throws Throwable 可能抛出的异常  
	 */
	public static MetaTable getBindingMetaTable(IMetaFactory metaFactory,MetaForm metaForm,String tableKey) throws Throwable {
		MetaDataSource dataSource = metaForm.getDataSource();
		if (dataSource == null) {
			return null;
		}
		MetaDataObject metaDataObject = dataSource.getDataObject();
		
		MetaTableCollection metaTableCollection = null;
		if (metaDataObject != null) {
			metaTableCollection = metaDataObject.getTableCollection();
		}

		MetaTable metaTable = null;
		if (tableKey != null && !tableKey.isEmpty() && metaTableCollection != null) {
			metaTable = metaTableCollection.get(tableKey);
		}
		
		return metaTable;
	}
	
	/**
	 * form 或 project 或 solution 的i18n文件夹 中查找公共词条
	 * @param metaFactory 配置工厂
	 * @param lang 语种
	 * @param formKey 表单标识
	 * @param group 组标识
	 * @param word 词条标识
	 * @param org 默认值
	 * @return 词文
	 * @throws Throwable 处理异常
	 */
	public static String getFormLocaleString(IMetaFactory metaFactory, String lang, String formKey, String group, String word, String org) throws Throwable{
		if(!metaFactory.getSolution().isEnableMultiLang()){
			return org;
		}
		
		String s = null;

		MetaStringTable strings = metaFactory.getFormStrings(formKey);

		if ( strings != null ) {
			s = strings.getString(lang, group, word);
		}
		
		if ( s == null ) {
			MetaForm metaForm = metaFactory.getMetaForm(formKey);
			strings = metaFactory.getProjectStrings(metaForm.getProjectKey());
			s = strings.getString(lang, group, word);
			if ( s == null ) {
				strings = metaFactory.getStrings();
				s = strings.getString(lang, group, word);
			}
		}
		
		if ( s == null ) {
			s = org;
		}
		
		return s;
	}
}
