package com.bokesoft.yes.meta.json.util;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAnchor;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBegin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBranchEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaComplexJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaCountersign;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataMap;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDecision;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEvent;
import com.bokesoft.yigo.meta.bpm.process.node.MetaExclusiveFork;
import com.bokesoft.yigo.meta.bpm.process.node.MetaExclusiveJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaFork;
import com.bokesoft.yigo.meta.bpm.process.node.MetaGateWay;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaManualTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageReceive;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageSend;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiUserTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.MetaServiceTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaState;
import com.bokesoft.yigo.meta.bpm.process.node.MetaStateAction;
import com.bokesoft.yigo.meta.bpm.process.node.MetaSubProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaTimer;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;

public class SerializeNodeUtil {

	public static List<MetaNode> unbuildNodes(JSONArray array) throws Throwable{
		List<MetaNode> list = new ArrayList<MetaNode>();
		for( int i = 0,size = array.length();i < size;i++ ) {
			JSONObject jsonObject = array.getJSONObject(i);
			String tagName = jsonObject.optString(JSONConstants.BPM_TAGNAME);
			MetaNode metaNode = unbuildNode(tagName, jsonObject);
			if(metaNode != null){
				list.add(metaNode);
			}
		}
		return list;
	}
	
	public static MetaNode unbuildNode(String tagName, JSONObject jsonObject) throws Throwable{
		Class<?> clazz = null;
		if (tagName.equalsIgnoreCase(MetaAudit.TAG_NAME)) {
			clazz = MetaAudit.class;
		} else if (tagName.equalsIgnoreCase(MetaBegin.TAG_NAME)) {
			clazz = MetaBegin.class;
		} else if (tagName.equalsIgnoreCase(MetaCountersign.TAG_NAME)) {
			clazz = MetaCountersign.class;
		} else if (tagName.equalsIgnoreCase(MetaDecision.TAG_NAME)) {
			clazz = MetaDecision.class;
		} else if (tagName.equalsIgnoreCase(MetaEnd.TAG_NAME)) {
			clazz = MetaEnd.class;
		} else if (tagName.equalsIgnoreCase(MetaEvent.TAG_NAME)) {
			clazz = MetaEvent.class;
		} else if (tagName.equalsIgnoreCase(MetaFork.TAG_NAME)) {
			clazz = MetaFork.class;
		} else if (tagName.equalsIgnoreCase(MetaJoin.TAG_NAME)) {
			clazz = MetaJoin.class;
		} else if (tagName.equalsIgnoreCase(MetaState.TAG_NAME)) {
			clazz = MetaState.class;
		} else if (tagName.equalsIgnoreCase(MetaSubProcess.TAG_NAME)) {
			clazz = MetaSubProcess.class;
		} else if (tagName.equalsIgnoreCase(MetaUserTask.TAG_NAME)) {
			clazz = MetaUserTask.class;
		} else if (tagName.equalsIgnoreCase(MetaTimer.TAG_NAME)) {
			clazz = MetaTimer.class;
		} else if (tagName.equalsIgnoreCase(MetaInline.TAG_NAME)) {
			clazz = MetaInline.class;
		} else if (tagName.equalsIgnoreCase(MetaDataMap.TAG_NAME)) {
			clazz = MetaDataMap.class;
		} else if (tagName.equalsIgnoreCase(MetaComplexJoin.TAG_NAME)) {
			clazz = MetaComplexJoin.class;
		} else if (tagName.equalsIgnoreCase(MetaExclusiveFork.TAG_NAME)) {
			clazz = MetaExclusiveFork.class;
		} else if (tagName.equalsIgnoreCase(MetaManualTask.TAG_NAME)) {
			clazz = MetaManualTask.class;
		} else if (tagName.equalsIgnoreCase(MetaServiceTask.TAG_NAME)) {
			clazz = MetaServiceTask.class;
		} else if (tagName.equalsIgnoreCase(MetaBranchEnd.TAG_NAME)) {
			clazz = MetaBranchEnd.class;
		} else if (tagName.equalsIgnoreCase(MetaStateAction.TAG_NAME)) {
			clazz = MetaStateAction.class;
		} else if (tagName.equalsIgnoreCase(MetaMultiUserTask.TAG_NAME)) {
			clazz = MetaMultiUserTask.class;
		} else if (tagName.equalsIgnoreCase(MetaMultiAudit.TAG_NAME)) {
			clazz = MetaMultiAudit.class;
		} else if (tagName.equalsIgnoreCase(MetaGateWay.TAG_NAME)) {
			clazz = MetaGateWay.class;
		} else if (tagName.equalsIgnoreCase(MetaMessageSend.TAG_NAME)) {
			clazz = MetaMessageSend.class;
		} else if (tagName.equalsIgnoreCase(MetaMessageReceive.TAG_NAME)) {
			clazz = MetaMessageReceive.class;
		} else if (tagName.equalsIgnoreCase(MetaExclusiveJoin.TAG_NAME)) {
			clazz = MetaExclusiveJoin.class;
		} else if (tagName.equalsIgnoreCase(MetaAnchor.TAG_NAME)){
			clazz = MetaAnchor.class;
		}
		return (MetaNode)BPMJSONHandlerUtil.unbuild(clazz, jsonObject);
	}
}
