package com.bokesoft.yes.meta.json.util;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yes.meta.json.ReportJSONHandlerMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;

public class ReportJSONHandlerUtil {
	
	/**
	 * 序列化一个配置对象
	 */
	public static JSONObject build(AbstractMetaObject meta, ISerializeContext hook) throws Throwable {
		String controlType = meta.getTagName();
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = ReportJSONHandlerMap.getHandler(controlType);
		JSONObject model = null;
		if (handler != null) {
			model = handler.toJSON(meta, hook);
		}
		return model;
	}
	
	/**
	 * 反序列化一个已知类型
	 */
	@SuppressWarnings("unchecked")
	public static <T> T unbuild(Class<T> clazz, JSONObject json) throws Throwable {
		AbstractMetaObject meta = (AbstractMetaObject)clazz.newInstance();
		String controlType = meta.getTagName();
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = ReportJSONHandlerMap.getHandler(controlType);
		if (handler != null) {
			handler.fromJSONImpl(meta, json);
		}
		return (T) meta;
	}
	
	/**
	 * 反序列化一个对象
	 */
	public static AbstractMetaObject unbuild(JSONObject json) throws Throwable {
		String tagName = json.optString(JSONConstants.COMMON_TAGNAME);
		AbstractMetaObject meta = null;
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = ReportJSONHandlerMap.getHandler(tagName);
		if (handler != null) {
			meta = handler.newInstance();
			handler.fromJSONImpl(meta, json);
		}
		return meta;
	}
	
	/**
	 * 反序列化一个已知内部类型集合
	 * @param clazz 内部类型
	 * @param array 集合json
	 */
	public static <T> List<T> unbuild(Class<T> clazz, JSONArray array) throws Throwable {
		List<T> list = new ArrayList<T>();
		for( int i = 0,size = array.length();i < size;i++ ) {
			list.add(unbuild(clazz, array.getJSONObject(i)));
		}
		return list;
	}
	
	/**
	 * 序列化GenericNoKeyCollection
	 */
	public static JSONArray buildNoKeyCollection(ISerializeContext hook, 
			GenericNoKeyCollection<? extends AbstractMetaObject> collection) throws Throwable {
		JSONArray array = new JSONArray();
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = null;
		for( AbstractMetaObject c : collection ) {
			handler = ReportJSONHandlerMap.getHandler(c.getTagName());
			if( handler != null ) {
				array.put(handler.toJSON(c, hook));
			}
		}
		return array;
	}
	
	/**
	 * 序列化GenericKeyCollection,可能有少数需要JSONObject类型,前台处理
	 */
	public static JSONArray buildKeyCollection(ISerializeContext hook, 
			GenericKeyCollection<? extends AbstractMetaObject> collection) throws Throwable {
		JSONArray array = new JSONArray();
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = null;
		for( AbstractMetaObject c : collection ) {
			handler = ReportJSONHandlerMap.getHandler(c.getTagName());
			if( handler != null ) {
				array.put(handler.toJSON(c, hook));
			}
		}
		return array;
	}
	
	/**
	 * 序列化GenericKeyCollectionWithKey
	 */
	public static JSONArray buildKeyWithKeyCollection(ISerializeContext hook, 
			GenericKeyCollectionWithKey<? extends AbstractMetaObject> collection) throws Throwable {
		JSONArray array = new JSONArray();
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = null;
		for( AbstractMetaObject c : collection ) {
			handler = ReportJSONHandlerMap.getHandler(c.getTagName());
			if( handler != null ) {
				array.put(handler.toJSON(c, hook));
			}
		}
		return array;
	}
	
	/**
	 * 序列化GenericNoKeyCollectionWithKey
	 */
	public static JSONArray buildNoKeyWithKeyCollection(ISerializeContext hook, 
			GenericNoKeyCollectionWithKey<? extends AbstractMetaObject> collection) throws Throwable {
		JSONArray array = new JSONArray();
		AbstractJSONHandler<AbstractMetaObject,ISerializeContext> handler = null;
		for( AbstractMetaObject c : collection ) {
			handler = ReportJSONHandlerMap.getHandler(c.getTagName());
			if( handler != null ) {
				array.put(handler.toJSON(c, hook));
			}
		}
		return array;
	}
}
