package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;

public abstract class MetaLayoutItemJSONHandler<T extends MetaLayoutItem> extends AbstractJSONHandler<T,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, T meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TAGNAME, meta.getTagName()); // 用于反序列化确定类型
	}
	
	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
	}

}
