package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSeparatorProperties;

public class MetaSeparatorPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaSeparatorProperties> {

	@Override
	public void toJSONImpl(JSONObject json, MetaSeparatorProperties meta, DefaultSerializeContext hook, String key)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.SEPARATOR_ORIENTATION, OrientationType.toString(meta.getOrientation()));
		JSONHelper.writeToJSON(json, JSONConstants.SEPARATOR_ICON, meta.getIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.SEPARATOR_ICONLOCATION, meta.getIconLocaltion(), IconLocationType.LEFT);
	}

	@Override
	public MetaSeparatorProperties newInstance() {
		return new MetaSeparatorProperties();
	}

	@Override
	public void fromJSONImpl(MetaSeparatorProperties meta, JSONObject json) throws Throwable {
		meta.setOrientation(OrientationType.parse(json.optString(JSONConstants.SEPARATOR_ORIENTATION)));
		meta.setIcon(json.optString(JSONConstants.SEPARATOR_ICON, ""));
		meta.setIconLocaltion(json.optInt(JSONConstants.SEPARATOR_ICONLOCATION, IconLocationType.LEFT));
	}

}
