package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDateRangePickerProperties;

public class MetaDateRangePickerPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaDateRangePickerProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDateRangePickerProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_RANGESEPARATOR, meta.getRangeSeparator());
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_STARTPLACEHOLDER, meta.getStartPlaceholder());
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_ENDPLACEHOLDER, meta.getEndPlaceholder());
		JSONHelper.writeToJSON(json, JSONConstants.DATERANGEPICKER_FORMATSTR, meta.getDateFormat());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText());
	}

	@Override
	public void fromJSONImpl(MetaDateRangePickerProperties meta, JSONObject json) throws Throwable {
		meta.setRangeSeparator(json.optString(JSONConstants.DATERANGEPICKER_RANGESEPARATOR));
		meta.setStartPlaceholder(json.optString(JSONConstants.DATERANGEPICKER_STARTPLACEHOLDER));
		meta.setEndPlaceholder(json.optString(JSONConstants.DATERANGEPICKER_ENDPLACEHOLDER));
		meta.setDateFormat(json.optString(JSONConstants.DATERANGEPICKER_FORMATSTR));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
	}

	@Override
	public MetaDateRangePickerProperties newInstance() {
		return new MetaDateRangePickerProperties();
	}
}

