package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountUpProperties;

public class MetaCountUpPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaCountUpProperties>{

	@Override
	public void toJSONImpl(JSONObject json, MetaCountUpProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COUNTUP_ROLLINGTYPE, meta.getRollingType());
		JSONHelper.writeToJSON(json, JSONConstants.COUNTUP_ROLLINGLINES, meta.getRollingLines());
	}

	@Override
	public void fromJSONImpl(MetaCountUpProperties meta, JSONObject json) throws Throwable {
		meta.setRollingType(json.optInt(JSONConstants.COUNTUP_ROLLINGTYPE));
		meta.setRollingLines(json.optInt(JSONConstants.COUNTUP_ROLLINGLINES));
	}

	@Override
	public MetaCountUpProperties newInstance() {
		return new MetaCountUpProperties();
	}

}
