package com.bokesoft.yes.meta.json.com.properties;

import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaItem;
/**
 * TODO 合并
 * @author Administrator
 *
 */
public class MetaComboFilterJSONHandler extends AbstractJSONHandler<MetaComboFilter,DefaultSerializeContext> {
	
	@Override
	public void fromJSONImpl(MetaComboFilter meta, JSONObject json) throws Throwable {
		
		meta.setType(json.optInt(JSONConstants.COMBOFILTER_TYPE));
		meta.setSourceType(json.optInt(JSONConstants.COMBOBOX_SOURCETYPE));
		meta.setItemsDependency(json.optString(JSONConstants.COMBOBOX_ITEMS_DEPENDENCY));
		
		
		String s = json.optString(JSONConstants.COMBOBOX_FORMULA);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
			script.setContent(s);
			meta.setFormulaItems(script);
		}
		
		int sourceType = meta.getSourceType();
		if( sourceType == ComboBoxSourceType.ITEMS ) {
			JSONArray array = json.optJSONArray(JSONConstants.COMBOBOX_ITEMS);
			if( array != null ) {
				List<MetaDefaultItem> list = UIJSONHandlerUtil.unbuild(MetaDefaultItem.class, array);
				meta.clear();
				meta.addAll(0, list);
			}
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.COMBOBOX_QUERYDEF);
		if( o != null ) {
			MetaQueryDef queryDef = UIJSONHandlerUtil.unbuild(MetaQueryDef.class, o);
			meta.setQueryDef(queryDef);
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaComboFilter meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMBOFILTER_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_ITEMS_DEPENDENCY, String.join(",", meta.getDependedFields()));

		
		MetaBaseScript formulaItems = meta.getFormulaItems();
		if( formulaItems != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_FORMULA, formulaItems.getContent().trim());
		}
		
		JSONArray array = null;
		if(meta.getSourceType() == ComboBoxSourceType.ITEMS && !meta.isEmpty()) {
			array = buildCommonItems(hook, meta);			
		}
	
		if( array != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_ITEMS, array);
		}
		
		MetaQueryDef queryDef = meta.getQueryDef();
		if( queryDef != null ) {
			JSONObject o = UIJSONHandlerUtil.build(queryDef,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_QUERYDEF, o);
		}
		
		// 添加依赖
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEPENDENCY, String.join(",", meta.getDependedFields()));
	}
	
	private JSONArray buildCommonItems( DefaultSerializeContext hook, MetaComboFilter comboFilter) throws Throwable {
		JSONArray array = new JSONArray();
		for (int i = 0; i < comboFilter.size(); i++) {
			MetaDefaultItem metaItem = comboFilter.get(i);
			JSONObject itemJSON = new JSONObject();
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_VALUE, metaItem.getValue());
			array.put(itemJSON);
		}
		return array;
	}
	
	private JSONArray buildStatusItems(DefaultSerializeContext hook, MetaStatusCollection statusCollection) throws Throwable {
		JSONArray array = new JSONArray();
		Iterator<MetaStatus> it = statusCollection.iterator();
		MetaStatus metaStatus = null;
		String caption = null;
		while (it.hasNext()) {
			metaStatus = it.next();
			JSONObject itemJSON = new JSONObject();
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_KEY, metaStatus.getKey());
			
			caption = hook.getString(GroupKeyTable.STR_STATUS, "", metaStatus.getKey(), metaStatus.getCaption());
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_CAPTION, caption);
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_VALUE, metaStatus.getValue(), Integer.MIN_VALUE);
			array.put(itemJSON);
		}
		return array;
	}
	
	private JSONArray buildGroupItems(DefaultSerializeContext hook,MetaParaGroup metaGroup) throws Throwable {
		JSONArray array = new JSONArray();
		Iterator<MetaParaItem> it = metaGroup.iterator();
		while (it.hasNext()) {
			MetaParaItem metaParaItem = it.next();
			JSONObject paraJSON = new JSONObject();
			JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_KEY, metaParaItem.getKey());
			
			String caption = hook.getString(GroupKeyTable.STR_PARAS, metaGroup.getKey(), metaParaItem.getKey(), metaParaItem.getCaption());
			JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_CAPTION, caption);
			JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_VALUE, metaParaItem.getValue());
			array.put(paraJSON);
		}
		return array;
	}

	@Override
	public MetaComboFilter newInstance() {
		return new MetaComboFilter();
	}

}

